/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;
import sonar.fluxnetworks.client.gui.basic.GuiPopupCore;
import sonar.fluxnetworks.common.connection.FluxMenu;

public abstract class GuiPopupHost
extends GuiFocusable {
    private GuiPopupCore<?> mCurrentPopup;

    protected GuiPopupHost(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
    }

    public final void openPopup(GuiPopupCore<?> popup) {
        if (popup == null || popup.mHost != this) {
            return;
        }
        this.closePopup();
        this.mCurrentPopup = popup;
        this.mCurrentPopup.m_6575_(this.getMinecraft(), this.f_96543_, this.f_96544_);
        this.onPopupOpen(this.mCurrentPopup);
    }

    protected void onPopupOpen(GuiPopupCore<?> popup) {
    }

    public final void closePopup() {
        if (this.mCurrentPopup != null) {
            this.onPopupClose(this.mCurrentPopup);
            this.mCurrentPopup.m_7379_();
            this.mCurrentPopup = null;
        }
    }

    protected void onPopupClose(GuiPopupCore<?> popup) {
    }

    @Nullable
    public final GuiPopupCore<?> getCurrentPopup() {
        return this.mCurrentPopup;
    }

    public final void m_94757_(double mouseX, double mouseY) {
        if (this.mCurrentPopup != null) {
            this.mCurrentPopup.m_94757_(mouseX, mouseY);
            return;
        }
        if (this.onMouseMoved(mouseX, mouseY)) {
            return;
        }
        super.m_94757_(mouseX, mouseY);
    }

    protected boolean onMouseMoved(double mouseX, double mouseY) {
        return false;
    }

    public final boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.m_6375_(mouseX, mouseY, mouseButton);
        }
        boolean result = this.onMouseClicked(mouseX, mouseY, mouseButton);
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_6375_(mouseX, mouseY, mouseButton)) continue;
            this.m_7522_(child);
            if (mouseButton == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        boolean focused = false;
        for (GuiEventListener child : this.m_6702_()) {
            EditBox editBox;
            if (!(child instanceof EditBox) || !(editBox = (EditBox)child).m_93696_()) continue;
            focused = true;
            break;
        }
        if (!focused) {
            this.m_7522_(null);
            return true;
        }
        return result;
    }

    protected boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public final boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.m_6348_(mouseX, mouseY, mouseButton);
        }
        return this.onMouseReleased(mouseX, mouseY, mouseButton) || super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public final boolean m_7979_(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.m_7979_(mouseX, mouseY, mouseButton, deltaX, deltaY);
        }
        return this.onMouseDragged(mouseX, mouseY, mouseButton, deltaX, mouseY) || super.m_7979_(mouseX, mouseY, mouseButton, deltaX, mouseY);
    }

    public boolean onMouseDragged(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        return false;
    }

    public final boolean m_6050_(double mouseX, double mouseY, double vScroll) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.m_6050_(mouseX, mouseY, vScroll);
        }
        return this.onMouseScrolled(mouseX, mouseY, vScroll) || super.m_6050_(mouseX, mouseY, vScroll);
    }

    public boolean onMouseScrolled(double mouseX, double mouseY, double vScroll) {
        return false;
    }

    @Override
    public final boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.m_7933_(keyCode, scanCode, modifiers);
        }
        return this.onKeyPressed(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public final boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.m_7920_(keyCode, scanCode, modifiers);
        }
        return this.onKeyReleased(keyCode, scanCode, modifiers) || super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public final boolean m_5534_(char c, int modifiers) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.m_5534_(c, modifiers);
        }
        return this.onCharTypes(c, modifiers) || super.m_5534_(c, modifiers);
    }

    public boolean onCharTypes(char c, int modifiers) {
        return false;
    }

    public void m_7856_() {
        super.m_7856_();
        if (this.mCurrentPopup != null) {
            this.mCurrentPopup.m_6575_(this.getMinecraft(), this.f_96543_, this.f_96544_);
        }
    }

    protected void drawForegroundLayer(PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
    }

    protected void drawBackgroundLayer(PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
    }

    public final void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, deltaTicks);
        this.drawForegroundLayer(poseStack, mouseX, mouseY, deltaTicks);
        if (this.mCurrentPopup != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 300.0);
            this.mCurrentPopup.drawBackgroundLayer(poseStack, mouseX, mouseY, deltaTicks);
            poseStack.m_85837_(0.0, 0.0, 10.0);
            this.mCurrentPopup.drawForegroundLayer(poseStack, mouseX, mouseY, deltaTicks);
            poseStack.m_85849_();
        }
    }

    protected final void m_7027_(@Nonnull PoseStack poseStack, int mouseX, int mouseY) {
    }

    protected final void m_7286_(@Nonnull PoseStack poseStack, float deltaTicks, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
        this.drawBackgroundLayer(poseStack, mouseX, mouseY, deltaTicks);
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        if (this.mCurrentPopup != null) {
            this.mCurrentPopup.m_181908_();
        }
    }
}

